"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import score_board

class TestScoreBoardMethods( unittest.TestCase ):

    def setUp( self ):
        self.expected_x = 125
        self.expected_y = 250
        self.expected_width = 400
        self.expected_height = 200

        self.board = score_board.ScoreBoard( self.expected_x, self.expected_y, self.expected_width, self.expected_height )
        
        return

    def tearDown( self ):
        return

    def test001_leftScores( self ):
        self.board.scoreLeft( )
        self.assertEqual( self.board.getLeftScore( ), 1 )
        return
    
    def test002_leftScoresMany( self ):
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.assertEqual( self.board.getLeftScore( ), 5 )
        return
    
    def test003_leftScoreStopsAtNine( self ):
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.assertEqual( self.board.getLeftScore( ), 9 )
        return
    
    def test004_rightScores( self ):
        self.board.scoreRight( )
        self.assertEqual( self.board.getRightScore( ), 1 )
        return
    
    def test005_rightScoresMany( self ):
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.assertEqual( self.board.getRightScore( ), 5 )
        return
    
    def test006_rightScoreStopsAtNine( self ):
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.board.scoreRight( )
        self.assertEqual( self.board.getRightScore( ), 9 )
        return
    
    def test007_gameIsNotOverNoScores( self ):
        self.assertEqual( self.board.isGameOver( ), False )
        return
    
    def test008_gameIsNotOverManyScores( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        self.assertEqual( self.board.isGameOver( ), False )
        return
    
    def test009_gameIsOverLeftWin( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        self.board.scoreLeft( )
        self.assertEqual( self.board.isGameOver( ), True )
        return
    
    def test010_gameIsOverLeftWinMany( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        for i in range( 8 ):
            self.board.scoreLeft( )
        self.assertEqual( self.board.isGameOver( ), True )
        return
    
    def test011_gameIsOverRightWin( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        self.board.scoreRight( )
        self.assertEqual( self.board.isGameOver( ), True )
        return
    
    def test011_gameIsOverRightWinMany( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        for i in range( 8 ):
            self.board.scoreRight( )
        self.assertEqual( self.board.isGameOver( ), True )
        return
    
    def test012_leftWins( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        for i in range( 8 ):
            self.board.scoreLeft( )
        self.assertEqual( self.board.getServeStatus( ), 3 )
        return
    
    def test013_rightWins( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        for i in range( 8 ):
            self.board.scoreRight( )
        self.assertEqual( self.board.getServeStatus( ), 4 )
        return
    
    def test014_leftWinsFirst( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        for i in range( 8 ):
            self.board.scoreLeft( )
        self.board.scoreRight( )
        self.assertEqual( self.board.getServeStatus( ), 3 )
        return
    
    def test015_rightWinsFirst( self ):
        for i in range( 8 ):
            self.board.scoreRight( )
            self.board.scoreLeft( )
        for i in range( 8 ):
            self.board.scoreRight( )
        self.board.scoreLeft( )
        self.assertEqual( self.board.getServeStatus( ), 4 )
        return
    
    def test016_serveSwapsToRight( self ):
        self.assertEqual( self.board.getServeStatus( ), 1 )
        self.board.swapServe( )
        self.assertEqual( self.board.getServeStatus( ), 2 )
        return

    def test017_serveSwapsToRight( self ):
        self.assertEqual( self.board.getServeStatus( ), 1 )
        self.board.swapServe( )
        self.assertEqual( self.board.getServeStatus( ), 2 )
        self.board.swapServe( )
        self.assertEqual( self.board.getServeStatus( ), 1 )
        return
    
    def test018_serveDoesNotSwapGameOverLeftWin( self ):
        for i in range( 9 ):
            self.board.scoreLeft( )
        self.assertEqual( self.board.getServeStatus( ), 3 )
        self.board.swapServe( )
        self.assertEqual( self.board.getServeStatus( ), 3 )
        return

    def test019_serveDoesNotSwapGameOverRightWin( self ):
        for i in range( 9 ):
            self.board.scoreRight( )
        self.assertEqual( self.board.getServeStatus( ), 4 )
        self.board.swapServe( )
        self.assertEqual( self.board.getServeStatus( ), 4 )
        return

    
def suite( ):
    return unittest.TestLoader( ).loadTestsFromTestCase( TestScoreBoardMethods )

if __name__ == '__main__':
    runner = unittest.TextTestRunner( )
    runner.run( suite( ) )
