"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import paddle

class TestPaddleMove( unittest.TestCase ):

    def setUp( self ):
        self.expected_x = 125
        self.expected_y = 250
        self.expected_width = 25
        self.expected_height = 100
        self.expected_speed = 90
        self.expected_min_y = 200
        self.expected_max_y = 800

        self.paddle = paddle.Paddle( self.expected_x, self.expected_y, self.expected_width, self.expected_height, self.expected_speed, self.expected_min_y, self.expected_max_y )
        
        return

    def tearDown( self ):
        return

    def test001_paddleMovesUp( self ):
        dt = 0.25
        y = 250
        expected_y = 227.5
        self.paddle.setPosition( y )
        self.paddle.moveUp( dt )
        
        self.assertAlmostEqual( self.paddle.getY( ), expected_y )
        return
    
    def test002_paddleMovesUpAndStopsAtTop( self ):
        dt = 0.25
        y = 210
        expected_y = 200
        self.paddle.setPosition( y )
        self.paddle.moveUp( dt )
        
        self.assertAlmostEqual( self.paddle.getY( ), expected_y )
        return
    
    def test003_paddleStaysAtTop( self ):
        dt = 0.25
        y = 200
        expected_y = 200
        self.paddle.setPosition( y )
        self.paddle.moveUp( dt )
        
        self.assertAlmostEqual( self.paddle.getY( ), expected_y )
        return

    def test004_paddleMovesDown( self ):
        dt = 0.25
        y = 250
        expected_y = 272.5
        self.paddle.setPosition( y )
        self.paddle.moveDown( dt )
        
        self.assertAlmostEqual( self.paddle.getY( ), expected_y )
        return
    
    def test005_paddleMovesDownAndStopsAtBottom( self ):
        dt = 0.25
        y = 681
        expected_y = 700
        self.paddle.setPosition( y )
        self.paddle.moveDown( dt )
        
        self.assertAlmostEqual( self.paddle.getY( ), expected_y )
        return
    
    def test006_paddleStaysAtBottom( self ):
        dt = 0.25
        y = 700
        expected_y = 700
        self.paddle.setPosition( y )
        self.paddle.moveDown( dt )
        
        self.assertAlmostEqual( self.paddle.getY( ), expected_y )
        return
    
def suite( ):
    return unittest.TestLoader( ).loadTestsFromTestCase( TestPaddleMove )

if __name__ == '__main__':
    runner = unittest.TextTestRunner( )
    runner.run( suite( ) )

