"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import paddle

class TestPaddleSetPosition( unittest.TestCase ):

    def setUp( self ):
        self.expected_x = 125
        self.expected_y = 250
        self.expected_width = 25
        self.expected_height = 100
        self.expected_speed = 90
        self.expected_min_y = 200
        self.expected_max_y = 800

        self.paddle = paddle.Paddle( self.expected_x, self.expected_y, self.expected_width, self.expected_height, self.expected_speed, self.expected_min_y, self.expected_max_y )
        
        return

    def tearDown( self ):
        return

    def test001_YIsSet( self ):
        y = 225
        self.paddle.setPosition( y )
        
        self.assertEqual( self.paddle.getY( ), y )
        return
    
    def test001_LowYIsSet( self ):
        y = 200
        self.paddle.setPosition( y )
        
        self.assertEqual( self.paddle.getY( ), y )
        return
    
    def test001_HighYIsSet( self ):
        y = 700
        self.paddle.setPosition( y )
        
        self.assertEqual( self.paddle.getY( ), y )
        return
    
    def test002_InvalidLowYIsNotSet( self ):
        y = 199
        self.paddle.setPosition( y )
        
        self.assertNotEqual( self.paddle.getY( ), y )
        return
    
    def test003_InvalidHighYIsNotSet( self ):
        y = 701
        self.paddle.setPosition( y )
        
        self.assertNotEqual( self.paddle.getY( ), y )
        return
    
def suite( ):
    return unittest.TestLoader( ).loadTestsFromTestCase( TestPaddleSetPosition )

if __name__ == '__main__':
    runner = unittest.TextTestRunner( )
    runner.run( suite( ) )
