"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import ball

class TestBallMove( unittest.TestCase ):

    def setUp( self ):
        self.expected_x = 0
        self.expected_y = 0
        self.expected_size = 13
        self.expected_dx = 0
        self.expected_dy = 0
        self.expected_min_x = 100
        self.expected_max_x = 900
        self.expected_min_y = 200
        self.expected_max_y = 800
        self.expected_left_paddle_x = 150
        self.expected_left_paddle_min_y = self.expected_min_y
        self.expected_left_paddle_max_y = self.expected_max_y
        self.expected_right_paddle_x = 850
        self.expected_right_paddle_min_y = self.expected_min_y
        self.expected_right_paddle_max_y = self.expected_max_y

        self.constructed_ball = ball.Ball( self.expected_size, self.expected_min_x, self.expected_max_x, self.expected_min_y, self.expected_max_y, self.expected_left_paddle_x, self.expected_right_paddle_x )
        
        return

    def tearDown( self ):
        return

    def test001_ballMoves( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 410
        ball_y = 420
        expected_x = 416.5
        expected_y = 427.5
        ball_dx = 13
        ball_dy = 15

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), ball_dx )
        self.assertEqual( self.constructed_ball.getDY( ), ball_dy )
        return
    
    
    def test002_ballMovesAndBouncesOffLeftPaddle( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 155
        ball_y = 420
        expected_x = 158
        expected_y = 435
        ball_dx = -26
        ball_dy = 30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), -ball_dx )
        self.assertEqual( self.constructed_ball.getDY( ), ball_dy )
        return
    
    def test003_ballMovesAndBouncesOffRightPaddle( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 835
        ball_y = 420
        expected_x = 826
        expected_y = 435
        ball_dx = 26
        ball_dy = 30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), -ball_dx )
        self.assertEqual( self.constructed_ball.getDY( ), ball_dy )
        return
    
    def test004_ballMovesAndBouncesOffTop( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 450
        ball_y = 210
        expected_x = 437.5
        expected_y = 204.5
        ball_dx = -25
        ball_dy = -29

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), ball_dx )
        self.assertEqual( self.constructed_ball.getDY( ), -ball_dy )
        return
    
    def test005_ballMovesAndBouncesOffBottom( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 450
        ball_y = 774
        expected_x = 437.5
        expected_y = 785.5
        ball_dx = -25
        ball_dy = 29

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), ball_dx )
        self.assertEqual( self.constructed_ball.getDY( ), -ball_dy )
        return
    

    def test006_ballMovesAndSticksToLeftWall( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 108
        ball_y = 420
        expected_x = 100
        expected_y = 435
        ball_dx = -26
        ball_dy = 30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), 0 )
        self.assertEqual( self.constructed_ball.getDY( ), 0 )
        return
    
    def test007_ballMovesAndSticksToRightWall( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 883
        ball_y = 420
        expected_x = 887
        expected_y = 435
        ball_dx = 26
        ball_dy = 30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), 0 )
        self.assertEqual( self.constructed_ball.getDY( ), 0 )
        return
    
    def test008_ballMovesBouncesAndSticksInUpperLeftCorner( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 105
        ball_y = 210
        expected_x = 100
        expected_y = 205
        ball_dx = -15
        ball_dy = -30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), 0 )
        self.assertEqual( self.constructed_ball.getDY( ), 0 )
        return
    
    def test009_ballMovesBouncesAndSticksInUpperRightCorner( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 885
        ball_y = 210
        expected_x = 887
        expected_y = 205
        ball_dx = 15
        ball_dy = -30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), 0 )
        self.assertEqual( self.constructed_ball.getDY( ), 0 )
        return
    
    
    def test010_ballMovesBouncesAndSticksInLowerRightCorner( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 885
        ball_y = 780
        expected_x = 887
        expected_y = 779
        ball_dx = 15
        ball_dy = 30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), 0 )
        self.assertEqual( self.constructed_ball.getDY( ), 0 )
        return
    
    def test011_ballMovesBouncesAndSticksInLowerLeftCorner( self ):
        paddle_min_y = 400
        paddle_max_y = 450

        dt = 0.5
        ball_x = 105
        ball_y = 780
        expected_x = 100
        expected_y = 779
        ball_dx = -15
        ball_dy = 30

        self.constructed_ball.setLeftPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setRightPaddleY( paddle_min_y, paddle_max_y )
        self.constructed_ball.setPosition( ball_x, ball_y )
        self.constructed_ball.setSpeed( ball_dx, ball_dy )
        
        self.constructed_ball.move( dt )
        
        self.assertAlmostEqual( self.constructed_ball.getX( ), expected_x )
        self.assertAlmostEqual( self.constructed_ball.getY( ), expected_y )
        self.assertEqual( self.constructed_ball.getDX( ), 0 )
        self.assertEqual( self.constructed_ball.getDY( ), 0 )
        return
    
def suite( ):
    return unittest.TestLoader( ).loadTestsFromTestCase( TestBallMove )

if __name__ == '__main__':
    runner = unittest.TextTestRunner( )
    runner.run( suite( ) )

