"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import ball

class TestBallSetSpeed( unittest.TestCase ):

    def setUp( self ):
        self.expected_x = 0
        self.expected_y = 0
        self.expected_size = 13
        self.expected_dx = 0
        self.expected_dy = 0
        self.expected_min_x = 100
        self.expected_max_x = 900
        self.expected_min_y = 200
        self.expected_max_y = 800
        self.expected_left_paddle_x = 150
        self.expected_left_paddle_min_y = self.expected_min_y
        self.expected_left_paddle_max_y = self.expected_max_y
        self.expected_right_paddle_x = 850
        self.expected_right_paddle_min_y = self.expected_min_y
        self.expected_right_paddle_max_y = self.expected_max_y

        self.constructed_ball = ball.Ball( self.expected_size, self.expected_min_x, self.expected_max_x, self.expected_min_y, self.expected_max_y, self.expected_left_paddle_x, self.expected_right_paddle_x )
        
        return

    def tearDown( self ):
        return

    def test001_PositiveDXIsSet( self ):
        dx = 3
        dy = 2
        self.constructed_ball.setSpeed( dx, dy )
        self.assertEqual( self.constructed_ball.getDX( ), dx )
        return
    
    def test002_PositiveDYIsSet( self ):
        dx = 3
        dy = 2
        self.constructed_ball.setSpeed( dx, dy )
        self.assertEqual( self.constructed_ball.getDY( ), dy )
        return
    
    def test003_NegativeDXIsSet( self ):
        dx = -3
        dy = -2
        self.constructed_ball.setSpeed( dx, dy )
        self.assertEqual( self.constructed_ball.getDX( ), dx )
        return
    
    def test004_NegativeDYIsSet( self ):
        dx = -3
        dy = -2
        self.constructed_ball.setSpeed( dx, dy )
        self.assertEqual( self.constructed_ball.getDY( ), dy )
        return
    
    
    def test005_PositiveDXAndNegativeDYAreSet( self ):
        dx = 3
        dy = -2
        self.constructed_ball.setSpeed( dx, dy )
        self.assertEqual( self.constructed_ball.getDX( ), dx )
        self.assertEqual( self.constructed_ball.getDY( ), dy )
        return
    
    def test006_NegativeDXAndPositiveDYAreSet( self ):
        dx = -3
        dy = 2
        self.constructed_ball.setSpeed( dx, dy )
        self.assertEqual( self.constructed_ball.getDX( ), dx )
        self.assertEqual( self.constructed_ball.getDY( ), dy )
        return
    
def suite( ):
    return unittest.TestLoader( ).loadTestsFromTestCase( TestBallSetSpeed )

if __name__ == '__main__':
    runner = unittest.TextTestRunner( )
    runner.run( suite( ) )
