"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import ball

class TestBallSetPosition( unittest.TestCase ):

    def setUp( self ):
        self.expected_x = 100
        self.expected_y = 200
        self.expected_size = 13
        self.expected_dx = 0
        self.expected_dy = 0
        self.expected_min_x = 100
        self.expected_max_x = 900
        self.expected_min_y = 200
        self.expected_max_y = 800
        self.expected_left_paddle_x = 150
        self.expected_left_paddle_min_y = self.expected_min_y
        self.expected_left_paddle_max_y = self.expected_max_y
        self.expected_right_paddle_x = 850
        self.expected_right_paddle_min_y = self.expected_min_y
        self.expected_right_paddle_max_y = self.expected_max_y

        self.constructed_ball = ball.Ball( self.expected_size, self.expected_min_x, self.expected_max_x, self.expected_min_y, self.expected_max_y, self.expected_left_paddle_x, self.expected_right_paddle_x )
        
        return

    def tearDown( self ):
        return

    def test001_XIsSet( self ):
        x = 167
        y = 267
        self.constructed_ball.setPosition( x, y )
        self.assertEqual( self.constructed_ball.getX( ), x )
        return
    
    def test002_YIsSet( self ):
        x = 167
        y = 267
        self.constructed_ball.setPosition( x, y )
        self.assertEqual( self.constructed_ball.getY( ), y )
        return
    
    def test003_InvalidLowXIsNotSet( self ):
        x = 99
        y = 267
        self.constructed_ball.setPosition( x, y )
        self.assertNotEqual( self.constructed_ball.getX( ), x )
        self.assertNotEqual( self.constructed_ball.getY( ), y )
        return
    
    def test004_InvalidHighXIsNotSet( self ):
        x = 888
        y = 267
        self.constructed_ball.setPosition( x, y )
        self.assertNotEqual( self.constructed_ball.getX( ), x )
        self.assertNotEqual( self.constructed_ball.getY( ), y )
        return
    
    def test005_InvalidLowYIsNotSet( self ):
        x = 167
        y = 199
        self.constructed_ball.setPosition( x, y )
        self.assertNotEqual( self.constructed_ball.getX( ), x )
        self.assertNotEqual( self.constructed_ball.getY( ), y )
        return
    
    def test006_InvalidHighYIsNotSet( self ):
        x = 167
        y = 788
        self.constructed_ball.setPosition( x, y )
        self.assertNotEqual( self.constructed_ball.getX( ), x )
        self.assertNotEqual( self.constructed_ball.getY( ), y )
        return

def suite( ):
    return unittest.TestLoader( ).loadTestsFromTestCase( TestBallSetPosition )

if __name__ == '__main__':
    runner = unittest.TextTestRunner( )
    runner.run( suite( ) )
