"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import isbn_index

class test_recordBook( unittest.TestCase ):
    
    def setUp(self):
        return

    def tearDown(self):
        return
    
    def test001_recordBookExists(self):
        self.assertTrue('recordBook' in dir( isbn_index ),
                        'Function "recordBook" is not defined, check your spelling')
        return
    
    def test002_recordBookStoresOneBook(self):
        isbn = "0000-00000000"
        title = "Book Title"
        expected = { isbn: title }
        
        index = isbn_index.createIndex( )
        isbn_index.recordBook( index, isbn, title )
        
        self.assertDictEqual( index, expected )
        return

    def test003_recordBookStoresTwoBooks(self):
        isbn1 = "0000-00000000"
        title1 = "Book Title"
        isbn2 = "0000-12345678"
        title2 = "War of the Worlds"
        expected = { isbn1: title1, isbn2: title2 }
        
        index = isbn_index.createIndex( )
        isbn_index.recordBook( index, isbn1, title1 )
        isbn_index.recordBook( index, isbn2, title2 )
        
        self.assertDictEqual( index, expected )
        return

    def test004_recordBookReplacesTitle(self):
        isbn1 = "0000-00000000"
        title1 = "Book Title"
        title2 = "War of the Worlds"
        expected = { isbn1: title2 }
        
        index = isbn_index.createIndex( )
        isbn_index.recordBook( index, isbn1, title1 )
        isbn_index.recordBook( index, isbn1, title2 )
        
        self.assertDictEqual( index, expected )
        return


if __name__ == '__main__':
    unittest.main()
