"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import isbn_index
import sys

class test_quitAction( unittest.TestCase ):

    def input_replacement( self, prompt ):
        self.assertFalse( self.too_many_inputs )
        self.input_given_prompt = prompt
        r = self.input_response_list[ self.input_response_index ]
        self.input_response_index += 1
        if self.input_response_index >= len( self.input_response_list ):
            self.input_response_index = 0
            self.too_many_inputs = True
        return r

    def print_replacement( self, *text ):
        line = " ".join( text ) + "\n"
        self.printed_lines.append( line )
        return

    def exit_replacement( self, value ):
        self.exit_called = True
        self.exit_value = value
        return
    
    def setUp(self):
        
        self.too_many_inputs = False
        self.input_given_prompt = None
        self.input_response_index = 0
        self.input_response_list = [ "" ]
        isbn_index.input = self.input_replacement

        self.printed_lines = [ ]
        isbn_index.print = self.print_replacement

        self.exit_called = False
        self.exit_value = -1
        return

    def tearDown(self):
        return
    
    def test001_quitActionExists(self):
        self.assertTrue('quitAction' in dir( isbn_index ),
                        'Function "quitAction" is not defined, check your spelling')
        return
    
    def test002_quitActionCallsExit(self):
        index = { }
        expected = { }

        self.input_response_list = [ "???" ]
        original_exit = sys.exit
        sys.exit = self.exit_replacement
        isbn_index.quitAction( index )
        sys.exit = original_exit
        self.assertDictEqual( index, expected )
        
        self.assertGreaterEqual( len( self.printed_lines ), 1 )
        self.assertTrue( self.exit_called )
        self.assertEqual( self.exit_value, 0 )
        
        return

if __name__ == '__main__':
    unittest.main()
