"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import re
import isbn_index

class test_listBooks( unittest.TestCase ):
    
    def setUp(self):
        self.isbn1 = "0000-00000000"
        self.title1 = "Book Title"
        self.isbn2 = "0000-12345678"
        self.title2 = "War of the Worlds"
        self.index = { self.isbn1: self.title1, self.isbn2: self.title2 }
        return

    def tearDown(self):
        return
    
    def test001_listBooksExists(self):
        self.assertTrue('listBooks' in dir( isbn_index ),
                        'Function "listBooks" is not defined, check your spelling')
        return
    
    def test002_listBooksGivesEmptyListForEmptyIndex(self):
        index = isbn_index.createIndex( )
        expected = [ ]
        self.assertListEqual( isbn_index.listBooks( index ), expected )
        return

    def test003_listBooksGivesAllElementsInIndex(self):
        expected = [ self.isbn1 + ".*" + self.title1,
                     self.isbn2 + ".*" + self.title2 ]
        book_list = isbn_index.listBooks( self.index )
        for expected_line in expected:
            found = False
            for actual_line in book_list:
                if re.search( expected_line, actual_line ):
                    found = True
                    break
            self.assertTrue( found, "'" + expected_line + "' not found in listBooks return" )
        return


    def test004_listBooksNumbersEntries(self):
        book_list = isbn_index.listBooks( self.index )
        self.assertEqual( book_list[0][0], "1" )
        self.assertEqual( book_list[1][0], "2" )
        return




if __name__ == '__main__':
    unittest.main()
