"""
Do Not Edit this file. You may and are encouraged to look at it for reference.
"""

import unittest
import isbn_index
import sys

class test_applyAction( unittest.TestCase ):

    def input_replacement( self, prompt ):
        self.assertFalse( self.too_many_inputs )
        self.input_given_prompt = prompt
        r = self.input_response_list[ self.input_response_index ]
        self.input_response_index += 1
        if self.input_response_index >= len( self.input_response_list ):
            self.input_response_index = 0
            self.too_many_inputs = True
        return r

    def print_replacement( self, *text ):
        line = " ".join( text ) + "\n"
        self.printed_lines.append( line )
        return

    def exit_replacement( self, value ):
        self.exit_called = True
        self.exit_value = value
        return

    def record_replacement( self, index ):
        self.record_called = True
        return
    
    def find_replacement( self, index ):
        self.find_called = True
        return
    
    def list_replacement( self, index ):
        self.list_called = True
        return
    
    def quit_replacement( self, index ):
        self.quit_called = True
        return
    
    def setUp(self):
        self.record_called = False
        self.find_called = False
        self.list_called = False
        self.quit_called = False
        
        self.too_many_inputs = False
        self.input_given_prompt = None
        self.input_response_index = 0
        self.input_response_list = [ "" ]
        isbn_index.input = self.input_replacement

        self.printed_lines = [ ]
        isbn_index.print = self.print_replacement

        self.exit_called = False
        self.exit_value = -1

        isbn_index.recordBookAction = self.record_replacement
        isbn_index.findBookAction = self.find_replacement
        isbn_index.listBooksAction = self.list_replacement
        isbn_index.quitAction = self.quit_replacement
        return

    def tearDown(self):
        return
    
    def test001_applyActionExists(self):
        self.assertTrue('applyAction' in dir( isbn_index ),
                        'Function "applyAction" is not defined, check your spelling')
        return
    
    def test002_applyActionCallsRecord(self):
        index = { }
        expected = { }

        isbn_index.applyAction( index, "r" )
        self.assertDictEqual( index, expected )

        self.assertTrue( self.record_called )
        self.assertFalse( self.find_called )
        self.assertFalse( self.list_called )
        self.assertFalse( self.quit_called )
        
        self.assertEqual( len( self.printed_lines ), 0 )

        return

    def test003_applyActionCallsFind(self):
        index = { }
        expected = { }

        isbn_index.applyAction( index, "f" )
        self.assertDictEqual( index, expected )

        self.assertFalse( self.record_called )
        self.assertTrue( self.find_called )
        self.assertFalse( self.list_called )
        self.assertFalse( self.quit_called )
        
        self.assertEqual( len( self.printed_lines ), 0 )

        return

    def test004_applyActionCallsList(self):
        index = { }
        expected = { }

        isbn_index.applyAction( index, "l" )
        self.assertDictEqual( index, expected )

        self.assertFalse( self.record_called )
        self.assertFalse( self.find_called )
        self.assertTrue( self.list_called )
        self.assertFalse( self.quit_called )
        
        self.assertEqual( len( self.printed_lines ), 0 )

        return

    def test005_applyActionCallsQuit(self):
        index = { }
        expected = { }

        isbn_index.applyAction( index, "q" )
        self.assertDictEqual( index, expected )

        self.assertFalse( self.record_called )
        self.assertFalse( self.find_called )
        self.assertFalse( self.list_called )
        self.assertTrue( self.quit_called )
        
        self.assertEqual( len( self.printed_lines ), 0 )

        return

    def test006_applyActionDetectsIllegalAction(self):
        index = { }
        expected = { }

        isbn_index.applyAction( index, "unexpected_action" )
        self.assertDictEqual( index, expected )

        self.assertFalse( self.record_called )
        self.assertFalse( self.find_called )
        self.assertFalse( self.list_called )
        self.assertFalse( self.quit_called )
        
        self.assertGreaterEqual( len( self.printed_lines ), 1 )

        return

if __name__ == '__main__':
    unittest.main()
